/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.patcher.plugin;

import catserver.server.patcher.IPatcher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CoreProtectPatcher
implements IPatcher {
    @Override
    public byte[] transform(String className, byte[] basicClass) {
        if (className.equals("net.coreprotect.CoreProtectAPI") || className.equals("net.coreprotect.Functions")) {
            return this.remapMaterial(basicClass);
        }
        return basicClass;
    }

    private byte[] remapMaterial(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode next : method.instructions) {
                if (!(next instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)next;
                if (methodInsnNode.owner.equals("org/bukkit/Material") && methodInsnNode.name.equals("getMaterial") && methodInsnNode.desc.equals("(Ljava/lang/String;)Lorg/bukkit/Material;")) {
                    methodInsnNode.name = "getItemOrBlockMaterial";
                    continue;
                }
                if (!methodInsnNode.owner.equals("org/bukkit/Material") || !methodInsnNode.name.equals("getMaterial") || !methodInsnNode.desc.equals("(I)Lorg/bukkit/Material;")) continue;
                methodInsnNode.name = "getBlockMaterial";
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

